/* npm t exercises/bigints/bit-set_test.mjs
Difficulty: ●●●

Instructions:
- Implement class BitSet
*/
suite('bit-set_test.mjs');

import assert from 'node:assert/strict';
import { BitSet } from './bit-set.mjs';

test('BitSet', () => {
  const bitSet = new BitSet([3n, 5n, 6n]);
  assert.deepEqual(
    Array.from(bitSet),
    [3n, 5n, 6n]
  );

  // Replace 5n with 4n

  assert.equal(
    bitSet.has(5n), true
  );
  bitSet.delete(5n);
  assert.equal(
    bitSet.has(5n), false
  );

  assert.equal(
    bitSet.has(4n), false
  );
  bitSet.add(4n);
  assert.equal(
    bitSet.has(4n), true
  );

  // Was 5n replaced with 4n?

  assert.deepEqual(
    Array.from(bitSet),
    [3n, 4n, 6n]
  );

  // Empty BitSet

  assert.deepEqual(
    new BitSet().values().toArray(),
    []
  );
});
