/* npm t exercises/bigints/parse-bigint_test.mjs
Difficulty: ●●○

Instructions:
- Implement parseBigInt(str, base=10n)
- Support a base up to 36 (all digits + all letters)
*/
suite('parse-bigint_test.mjs');

import assert from 'node:assert/strict';
import { parseBigInt } from './parse-bigint.mjs';

test('parseBigInt()', () => {
  assert.equal(
    parseBigInt('100'), 100n,
    'Default base is 10'
  );
  assert.equal(
    parseBigInt('99', 10n), 99n
  );

  assert.equal(
    parseBigInt('1111', 2n), 15n,
    'Positive binary number'
  );
  assert.equal(
    parseBigInt('-1111', 2n), -15n,
    'Negative binary number'
  );

  assert.equal(
    parseBigInt('FF', 16n), 255n,
    'Uppercase letters'
  );
  assert.equal(
    parseBigInt('ff', 16n), 255n,
    'Lowercase letters'
  );
  
  assert.equal(
    parseBigInt('Z', 36n), 35n,
    'Highest base is 36'
  );
  assert.equal(
    parseBigInt('zz', 36n), (36n * 36n) - 1n
  );

  assert.throws(
    () => parseBigInt('0', 1n),
    {
      name: 'RangeError',
      message: 'Base is out of range: 1',
    }
  );
  assert.throws(
    () => parseBigInt('0', 37n),
    {
      name: 'RangeError',
      message: 'Base is out of range: 37',
    }
  );
});
