/* npm t exercises/objects/null-proto-obj-dict_test.mjs
Difficulty: ●○○

Instructions:
- Implement the imported functionality.
- Use an object with a `null` prototype to do so.
- This exercise demonstrates why objects with `null` prototypes are good
  dictionary objects.
- Related exercise: exercises/objects/plain-object-dict_test.mjs
*/
suite('null-proto-obj-dict_test.mjs');

import assert from 'node:assert/strict';
import { createDict, setValue, getValue, hasKey, getKeys } from './null-proto-obj-dict.mjs';

test('Using dictionaries created via createDict()', () => {
  const dict = createDict();
  
  setValue(dict, '__proto__', 'abc');
  assert.equal(getValue(dict, '__proto__'), 'abc');
  assert.ok(hasKey(dict, '__proto__'));

  setValue(dict, 'normal', true);
  assert.equal(getValue(dict, 'normal'), true);
  assert.ok(hasKey(dict, 'normal'));
  
  assert.deepEqual(hasKey(dict, 'toString'), false);
  
  // Keys are listed in creation order!
  assert.deepEqual(getKeys(dict), ['__proto__', 'normal']);
});
