const LOOKUP_TABLE = '0123456789abcdefghijklmnopqrstuvwxyz';
const MAX_BASE = BigInt(LOOKUP_TABLE.length);

export function parseBigInt(str, base = 10n) {
  str = String(str);
  if (typeof base !== 'bigint') {
    throw new TypeError('Base must be a bigint');
  }
  if (base < 2n || base > MAX_BASE) {
    throw new RangeError('Base is out of range: ' + base);
  }
  let sign = 1n;
  if (str.startsWith('-')) {
    sign = -1n;
    str = str.slice(1);
  }
  let result = 0n;
  for (const digit of str) {
    // Shift existing digits left to make room for new digit
    result *= base;
    const digitValue = LOOKUP_TABLE.indexOf(digit.toLowerCase());
    if (digitValue < 0 || digitValue >= base) {
      throw new RangeError('Illegal digit: ' + digit);
    }
    result += BigInt(digitValue);
  }
  return result * sign;
}
