export function createDict() {
  return {};
}

export function setValue(dict, key, value) {
  key = encodeKey(key);
  dict[key] = value;
}

export function getValue(dict, key) {
  key = encodeKey(key);
  if (Object.hasOwn(dict, key)) {
    return dict[key];
  } else {
    return undefined;
  }
}

export function hasKey(dict, key) {
  key = encodeKey(key);
  return Object.hasOwn(dict, key);
}

export function getKeys(dict) {
  // Only lists own (non-inherited) properties
  return Object.keys(dict).map(k => decodeKey(k));
}

function encodeKey(key) {
  if (key.startsWith('__proto__')) {
    // We need to be safe and encode even an escaped '__proto__' so that it
    // isn’t mistaken for a normal '__proto__'.
    return key + '%';
  }
  return key;
}
function decodeKey(key) {
  if (key.startsWith('__proto__')) {
    // Remove the '%' that was added by encoding.
    return key.slice(0, -1);
  }
  return key;
}